<?php
function verifyCrashGame($serverSeed, $hashedServerSeed, $clientSeed, $nonce) {
    $computedHash = hash('sha256', $serverSeed);
    if (strtolower($computedHash) !== strtolower($hashedServerSeed)) {
        return ['error' => '❌ La semilla del servidor no coincide con el hash anunciado.'];
    }

    $message = $clientSeed . ':' . $nonce;
    $roundHash = hash_hmac('sha256', $message, $serverSeed);

    $h = intval(substr($roundHash, 0, 13), 16);
    if ($h % 33 === 0) {
        $multiplier = 0.00;
    } else {
        $e = pow(2, 52);
        $multiplier = floor((($e - 1) / ($e - $h)) * 100) / 100;
    }

    return [
        'hash_calculado' => $roundHash,
        'multiplicador'  => $multiplier
    ];
}
?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <title>Verificador Provably Fair</title>
    <style>
        body { font-family: Arial, sans-serif; background: #f4f4f4; padding: 40px; }
        form { background: #fff; padding: 20px; border-radius: 8px; max-width: 500px; margin: auto; box-shadow: 0 2px 10px rgba(0,0,0,0.1); }
        input[type="text"], input[type="number"] { width: 100%; padding: 10px; margin-top: 10px; border: 1px solid #ccc; border-radius: 4px; }
        input[type="submit"] { background: #28a745; color: #fff; border: none; padding: 12px; width: 100%; margin-top: 20px; border-radius: 4px; font-size: 16px; cursor: pointer; }
        .resultado { background: #fff; padding: 20px; margin-top: 20px; border-radius: 8px; max-width: 500px; margin: auto; box-shadow: 0 2px 10px rgba(0,0,0,0.1); }
        .error { color: red; }
    </style>
</head>
<body>

<h2 style="text-align: center;">🔍 Verificador Provably Fair</h2>

<form method="POST">
    <label>Semilla del servidor (revelada):</label>
    <input type="text" name="server_seed" required>

    <label>Hash del servidor (mostrado antes de jugar):</label>
    <input type="text" name="hashed_server_seed" required>

    <label>Semilla del cliente:</label>
    <input type="text" name="client_seed" required>

    <label>Número de ronda (nonce):</label>
    <input type="number" name="nonce" min="1" required>

    <input type="submit" value="Verificar">
</form>

<?php
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $serverSeed = $_POST['server_seed'];
    $hashedSeed = $_POST['hashed_server_seed'];
    $clientSeed = $_POST['client_seed'];
    $nonce = intval($_POST['nonce']);

    $result = verifyCrashGame($serverSeed, $hashedSeed, $clientSeed, $nonce);

    echo '<div class="resultado">';
    if (isset($result['error'])) {
        echo '<p class="error">' . $result['error'] . '</p>';
    } else {
        echo "<p><strong>✅ Verificación exitosa</strong></p>";
        echo "<p><strong>Hash de ronda:</strong> {$result['hash_calculado']}</p>";
        echo "<p><strong>Multiplicador:</strong> {$result['multiplicador']}x</p>";
    }
    echo '</div>';
}
?>

</body>
</html>
