<?php
/**
 * rescate_wallet_v4.php
 * Rescate · Withdraw on-chain (Wallet v4) con UI Async.
 * Endpoints internos (?api=1&op=auth|deposit|wl|onestep|withdraw)
 */

session_start();
ini_set('display_errors', 0);
error_reporting(E_ALL);

/* ────────────────────────────── [1] CONFIG ────────────────────────────── */
$API_BASE   = 'https://api.notbank.exchange';
$API_KEY    = '40b266e4f2f010631ddfb26cda4d915a';
$API_SECRET = '5bc92a8df76d2d88248590e0fef53ecc';
$USER_ID    = 1081;
$ACCOUNT_ID = 4231;

$CURRENCY = 'USDT';
$NETWORK  = 'USDT_BSC'; // Normalizado

/* ─────────────────────── [2] HTTP CORE (robusto) ─────────────────────── */
function http_json($method, $url, array $headers = [], $payload = null) {
  static $CJ = null;
  if ($CJ === null) {
    $CJ = sys_get_temp_dir().'/nb_cf_cookiejar_'.substr(md5(__FILE__),0,8).'.txt';
  }

  // dedup de headers (case-insensitive)
  $norm = [];
  foreach ($headers as $h) {
    $p = strpos($h, ':');
    if ($p !== false) {
      $k = strtolower(trim(substr($h, 0, $p)));
      $norm[$k] = $h;
    }
  }
  foreach ([
    'accept'       => 'Accept: application/json',
    'content-type' => 'Content-Type: application/json',
    'user-agent'   => 'User-Agent: nb-client/1.3 (+wallet-v4)',
    'connection'   => 'Connection: close',
  ] as $k=>$v) if (!isset($norm[$k])) $norm[$k] = $v;
  $h = array_values($norm);

  $ch = curl_init($url);
  if (strtoupper($method) === 'POST') {
    curl_setopt($ch, CURLOPT_POST, true);
    $body = ($payload === null) ? '' : (is_string($payload) ? $payload : json_encode($payload));
    curl_setopt($ch, CURLOPT_POSTFIELDS, $body);
  } else {
    curl_setopt($ch, CURLOPT_HTTPGET, true);
  }

  curl_setopt_array($ch, [
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_TIMEOUT        => 30,
    CURLOPT_HTTPHEADER     => $h,
    CURLOPT_HEADER         => true,
    CURLOPT_ENCODING       => '',  // gzip/deflate
    CURLOPT_COOKIEJAR      => $CJ,
    CURLOPT_COOKIEFILE     => $CJ,
    CURLOPT_FAILONERROR    => false,
    CURLOPT_HTTP_VERSION   => CURL_HTTP_VERSION_1_1,
  ]);

  $resp = curl_exec($ch);
  $info = curl_getinfo($ch);
  curl_close($ch);

  $hs = $info['header_size'] ?? 0;
  $rawHeaders = substr($resp, 0, $hs);
  $rawBody    = substr($resp, $hs);

  $cf_ray = null; $isHtml = false;
  foreach (preg_split("/\r\n|\n|\r/", (string)$rawHeaders) as $line) {
    if (stripos($line,'cf-ray:') === 0) { $cf_ray = trim(substr($line, 7)); break; }
  }
  $isHtml  = stripos($rawBody, '<html') !== false;
  $trimmed = ltrim($rawBody, "\xEF\xBB\xBF \t\r\n");
  $json    = json_decode($trimmed, true);
  if (!is_array($json) && preg_match('/\{.*\}/s', $trimmed, $m)) $json = json_decode($m[0], true);

  return [
    'http'      => (int)($info['http_code'] ?? 0),
    'body_raw'  => $rawBody,
    'json'      => is_array($json) ? $json : null,
    'is_html'   => $isHtml,
    'cf_ray'    => $cf_ray,
    'hdrs_raw'  => $rawHeaders,
  ];
}

/* ───────────────────────── [3] HELPERS comunes ───────────────────────── */
function sign_auth($nonce, $userId, $apiKey, $apiSecret) {
  return hash_hmac('sha256', (string)$nonce.(string)$userId.(string)$apiKey, $apiSecret);
}
function decstr($n, $d = 8) {
  $s = number_format((float)$n, $d, '.', '');
  $s = rtrim(rtrim($s, '0'), '.');
  return $s === '' ? '0' : $s;
}
function normalize_network($currency, $network) {
  $c = strtoupper(trim($currency));
  $n = strtoupper(str_replace('-', '_', trim($network)));
  $map = ['BEP20'=>'BSC','ERC20'=>'ETH','TRC20'=>'TRC'];
  if (isset($map[$n])) $n = $map[$n];
  if (preg_match('/^'.$c.'_(BSC|ETH|TRC|SOL)$/', $n)) return $n;
  if (in_array($n, ['BSC','ETH','TRC','SOL'], true)) return $c.'_'.$n;
  if (preg_match('/^([A-Z]+)(BSC|ETH|TRC|SOL)$/', $n, $m)) return $m[1].'_'.$m[2];
  return $n;
}
function uuidv4() {
  $d = random_bytes(16);
  $d[6] = chr((ord($d[6]) & 0x0f) | 0x40);
  $d[8] = chr((ord($d[8]) & 0x3f) | 0x80);
  return vsprintf('%s%s-%s-%s-%s-%s%s%s', str_split(bin2hex($d), 4));
}

/* ─────────────────────────── [4] AUTH / TOKEN ─────────────────────────── */
function op_auth() {
  global $API_BASE, $API_KEY, $API_SECRET, $USER_ID;
  $now = microtime(true);
  if (!empty($_SESSION['aptoken']) && ($now - ($_SESSION['last_auth_ts'] ?? 0)) < 2.0) {
    return ['ok'=>true, 'token'=>$_SESSION['aptoken'], 'http'=>200, 'body'=>'<cached>'];
  }
  $genNonce = function() {
    $ms = (int)round(microtime(true)*1000);
    $last = $_SESSION['last_nonce'] ?? 0;
    if ($ms <= $last) $ms = $last + 1;
    $_SESSION['last_nonce'] = $ms;
    return (string)$ms;
  };

  $last = ['http'=>0,'body_raw'=>'<no-body>'];
  for ($i=0;$i<3;$i++) {
    $nonce = $genNonce();
    $sig   = sign_auth($nonce, $USER_ID, $API_KEY, $API_SECRET);
    $res = http_json('POST', rtrim($API_BASE,'/').'/AP/AuthenticateUser', [
      'APIKey: '.$API_KEY,
      'Signature: '.$sig,
      'UserId: '.$USER_ID,
      'Nonce: '.$nonce,
    ], null);

    $tok = null;
    if (is_array($res['json'])) {
      $tok = $res['json']['SessionToken'] ?? $res['json']['sessionToken'] ?? ($res['json']['data']['SessionToken'] ?? null);
    }
    if (!$tok && !empty($res['body_raw'])) {
      if (preg_match('/"SessionToken"\s*:\s*"([^"]+)"/i', $res['body_raw'], $m)) $tok = $m[1];
      elseif (preg_match('/"sessionToken"\s*:\s*"([^"]+)"/i', $res['body_raw'], $m)) $tok = $m[1];
    }
    if ($tok) {
      $_SESSION['aptoken'] = $tok;
      $_SESSION['last_auth_ts'] = microtime(true);
      return ['ok'=>true, 'token'=>$tok, 'http'=>$res['http'], 'body'=>'<parsed>'];
    }
    usleep(250000);
    $last = $res;
  }
  return ['ok'=>false, 'token'=>null, 'http'=>$last['http'] ?? 0, 'body'=>$last['body_raw'] ?? '<no-body>'];
}
function ensure_token(){ if (!empty($_SESSION['aptoken'])) return true; $a=op_auth(); return !empty($a['ok']); }
function auth_header() {
  $tok = $_SESSION['aptoken'] ?? '';
  return [
    'Accept: application/json',
    'Content-Type: application/json',
    'User-Agent: nb-client/1.3 (+wallet-v4)',
    "aptoken: $tok",
  ];
}

/* ─────────────────────── [5] LECTURAS BÁSICAS ────────────────────────── */
function op_deposit_addr($accountId, $currency, $network) {
  global $API_BASE;
  if (!ensure_token()) return ['ok'=>false, 'address'=>'', 'raw'=>['http'=>0,'body_raw'=>'<no aptoken>']];
  $url = rtrim($API_BASE,'/').'/api/nb/wallet/crypto?account_id='.(int)$accountId.'&currency='.urlencode(strtoupper($currency)).'&network='.urlencode(normalize_network($currency,$network));
  $res = http_json('GET', $url, auth_header());
  if (in_array($res['http'], [401,403])) { if (ensure_token()) $res = http_json('GET', $url, auth_header()); }
  $addr = '';
  if ($res['http']===200 && is_array($res['json']['data'] ?? null) && count($res['json']['data'])>0) $addr = $res['json']['data'][0];
  return ['ok'=>$res['http']===200, 'address'=>$addr, 'raw'=>$res];
}

function op_whitelist_search($accountId, $query) {
  global $API_BASE;
  if (!ensure_token()) return ['ok'=>false,'rows'=>[],'raw'=>['http'=>0,'body_raw'=>'<no aptoken>']];
  $url = rtrim($API_BASE,'/').'/api/nb/wallet/crypto/whitelist-addresses?account_id='.(int)$accountId.'&search='.urlencode($query);
  $res = http_json('GET', $url, auth_header());
  if (in_array($res['http'], [401,403])) { if (ensure_token()) $res = http_json('GET', $url, auth_header()); }
  $rows = [];
  if ($res['http']===200 && is_array($res['json']['data'] ?? null)) $rows = $res['json']['data'];
  return ['ok'=>$res['http']===200, 'rows'=>$rows, 'raw'=>$res];
}

/* ───────────────────── [6] ONE-STEP WITHDRAW v4] ─────────────────────── */
function op_onestep_toggle($accountId, $action, $otp = null) {
  global $API_BASE;
  if (!ensure_token()) return ['ok'=>false,'raw'=>['http'=>0,'body_raw'=>'<no aptoken>']];
  $url = rtrim($API_BASE,'/').'/api/nb/wallet/crypto/withdrawal/onestep';
  $payload = [
    'account_id' => (int)$accountId,
    'action'     => $action, // "enable"|"disable"|"status" (según doc)
  ];
  if ($otp !== null && $otp !== '') $payload['otp'] = (string)$otp;

  $headers = auth_header();
  $headers[] = 'X-Idempotency-Key: '.uuidv4();

  $res = http_json('POST', $url, $headers, $payload);
  if (in_array($res['http'], [401,403])) {
    $a = op_auth();
    if (!empty($a['token'])) {
      $headers = auth_header();
      $headers[] = 'X-Idempotency-Key: '.uuidv4();
      $res = http_json('POST', $url, $headers, $payload);
    }
  }
  return ['ok'=>($res['http']>=200 && $res['http']<300 && (strtolower($res['json']['status'] ?? '')==='success')), 'raw'=>$res, 'sent'=>$payload];
}

/* ───── [7] WITHDRAW v4 — CreateCryptoWithdraw (variantes A→B) ───── */
function wallet_create_withdraw($accountId, $currency, $network, $toAddress, $amountStr, $otpInput = null) {
  global $API_BASE;

  // 1) buscar whitelist para la dirección
  $wl_id = null; $prov = null;
  $wl = op_whitelist_search($accountId, $toAddress);
  if (!empty($wl['rows'])) {
    foreach ($wl['rows'] as $row) {
      if (strcasecmp($row['address'] ?? '', $toAddress)===0 && !empty($row['verified'])) {
        $wl_id = $row['id'] ?? null;
        $prov  = $row['provider_id'] ?? null;
        break;
      }
    }
  }

  $endpoint = rtrim($API_BASE,'/').'/api/nb/wallet/crypto/withdrawal';
  $base = [
    'account_id' => (int)$accountId,
    'currency'   => strtoupper($currency),
    'network'    => normalize_network($currency,$network),
    'address'    => (string)$toAddress,
    // amount SIEMPRE string
    'amount'     => (string)$amountStr,
  ];
  $build = function(array $extra = []) use ($base, $otpInput) {
    $p = $base;
    foreach ($extra as $k=>$v) $p[$k] = $v;
    // OTP solo si el usuario lo manda explícitamente (o si luego el backend lo pide).
    if ($otpInput !== null && $otpInput !== '') $p['otp'] = (string)$otpInput;
    return $p;
  };

  $variants = [
    ['name'=>'A', 'payload'=>$build([])], // mínimo
    ['name'=>'B', 'payload'=>$build(array_filter([
      'whitelist_id' => $wl_id,
      'provider_id'  => $prov ? (int)$prov : null,
    ], fn($v)=>$v!==null))],
  ];

  $last = null;
  foreach ($variants as $v) {
    $headers = auth_header();
    $headers[] = 'X-Idempotency-Key: '.uuidv4();

    $res = http_json('POST', $endpoint, $headers, $v['payload']);

    // reauth 1 vez si 401/403
    if (in_array($res['http'], [401,403])) {
      $a = op_auth();
      if (!empty($a['token'])) {
        $headers = auth_header();
        $headers[] = 'X-Idempotency-Key: '.uuidv4();
        $res = http_json('POST', $endpoint, $headers, $v['payload']);
      }
    }

    // Éxito
    if ($res['http']>=200 && $res['http']<300 && is_array($res['json'])) {
      if (strtolower($res['json']['status'] ?? '')==='success') {
        return ['ok'=>true, 'id'=>$res['json']['data']['id'] ?? null, 'raw'=>$res, 'variant'=>$v['name']];
      }
    }

    // required_token → necesita OTP
    if ($res['http']===401 && (($res['json']['code'] ?? '')==='required_token')) {
      return ['ok'=>false, 'need_otp'=>true, 'raw'=>$res, 'variant'=>$v['name'], 'payload'=>$v['payload']];
    }
    // invalid_token → OTP inválido/ya usado
    if ($res['http']===401 && (($res['json']['code'] ?? '')==='invalid_token')) {
      return ['ok'=>false, 'why'=>'invalid_token', 'raw'=>$res, 'variant'=>$v['name'], 'payload'=>$v['payload']];
    }
    // 400 con HTML → WAF
    if ($res['http']===400 && ($res['is_html'] ?? false)) {
      return ['ok'=>false, 'why'=>'bad_request_waf', 'raw'=>$res, 'variant'=>$v['name'], 'payload'=>$v['payload']];
    }
    // 500 → intentar siguiente variante
    if ($res['http']===500) {
      $last = ['ok'=>false,'why'=>'internal_error','raw'=>$res,'variant'=>$v['name'],'payload'=>$v['payload']];
      usleep(250000);
      continue;
    }
    // otros 4xx
    if ($res['http']>=400 && $res['http']<500) {
      return ['ok'=>false, 'why'=>'client_error', 'raw'=>$res, 'variant'=>$v['name'], 'payload'=>$v['payload']];
    }
    $last = ['ok'=>false, 'why'=>'unexpected', 'raw'=>$res, 'variant'=>$v['name'], 'payload'=>$v['payload']];
  }

  return $last ?: ['ok'=>false,'why'=>'exhausted'];
}

/* ─────────────── [8] API mini (?api=1&op=*) ─────────────── */
if (isset($_GET['api'])) {
  header('Content-Type: application/json; charset=utf-8');
  $op = $_GET['op'] ?? '';
  try {
    if ($op === 'auth') {
      $r = op_auth();
      echo json_encode([
        'ok'=>$r['ok'],
        'token'=>$r['token'] ? (substr($r['token'],0,8).'•••'.substr($r['token'],-4)) : null,
        'http'=>$r['http'],
        'body'=>$r['body'],
      ], JSON_UNESCAPED_UNICODE); exit;
    }

    if ($op === 'deposit') {
      $r = op_deposit_addr($ACCOUNT_ID, $CURRENCY, $NETWORK);
      echo json_encode([
        'ok'=>$r['ok'],
        'http'=>$r['raw']['http'] ?? 0,
        'cf_ray'=>$r['raw']['cf_ray'] ?? null,
        'body'=>$r['raw']['body_raw'] ?? '',
        'address'=>$r['address'],
        'has_token'=> !empty($_SESSION['aptoken']),
      ], JSON_UNESCAPED_UNICODE); exit;
    }

    if ($op === 'wl') {
      $q = $_POST['q'] ?? $_GET['q'] ?? '';
      $r = op_whitelist_search($ACCOUNT_ID, $q);
      echo json_encode([
        'ok'=>$r['ok'],
        'http'=>$r['raw']['http'] ?? 0,
        'cf_ray'=>$r['raw']['cf_ray'] ?? null,
        'body'=>$r['raw']['body_raw'] ?? '',
        'rows'=>$r['rows'],
      ], JSON_UNESCAPED_UNICODE); exit;
    }

    if ($op === 'onestep') {
      $action = $_POST['action'] ?? 'status'; // enable|disable|status
      $otp    = $_POST['otp'] ?? null;
      $r = op_onestep_toggle($ACCOUNT_ID, $action, $otp ?: null);
      echo json_encode([
        'ok'=>$r['ok'],
        'http'=>$r['raw']['http'] ?? 0,
        'cf_ray'=>$r['raw']['cf_ray'] ?? null,
        'body'=>$r['raw']['body_raw'] ?? '',
        'sent'=>$r['sent'] ?? null,
      ], JSON_UNESCAPED_UNICODE); exit;
    }

    if ($op === 'withdraw') {
      $to  = $_POST['to']  ?? '';
      $amt = $_POST['amt'] ?? '';
      $otp = $_POST['otp'] ?? null;

      if (!ensure_token()) { echo json_encode(['ok'=>false,'why'=>'no_aptoken']); exit; }
      if ($to==='')        { echo json_encode(['ok'=>false,'why'=>'missing_to']); exit; }
      if ($amt==='' || !is_numeric($amt)) { echo json_encode(['ok'=>false,'why'=>'invalid_amount']); exit; }

      $amountStr = decstr($amt, 8);
      $r = wallet_create_withdraw($ACCOUNT_ID, $CURRENCY, $NETWORK, $to, $amountStr, $otp ?: null);

      if (!empty($r['ok'])) {
        echo json_encode([
          'ok'=>true,
          'id'=>$r['id'] ?? null,
          'variant'=>$r['variant'] ?? null,
          'http'=>$r['raw']['http'] ?? 200,
          'cf_ray'=>$r['raw']['cf_ray'] ?? null,
          'body'=>$r['raw']['body_raw'] ?? '{"status":"success"}',
          'sent'=>[
            'account_id'=>$ACCOUNT_ID,
            'currency'=>strtoupper($CURRENCY),
            'network'=>normalize_network($CURRENCY,$NETWORK),
            'address'=>$to,
            'amount'=>$amountStr,
            'otp'=>($otp ? '<provided>' : '<none>'),
          ],
        ], JSON_UNESCAPED_UNICODE); exit;
      }

      if (!empty($r['need_otp'])) {
        echo json_encode([
          'ok'=>false,
          'need_otp'=>true,
          'variant'=>$r['variant'] ?? null,
          'http'=>$r['raw']['http'] ?? 401,
          'cf_ray'=>$r['raw']['cf_ray'] ?? null,
          'body'=>$r['raw']['body_raw'] ?? '',
          'hint'=>'El backend exige OTP. Ingresa un TOTP fresco y reintenta.',
        ], JSON_UNESCAPED_UNICODE); exit;
      }

      echo json_encode([
        'ok'=>false,
        'why'=>$r['why'] ?? 'failure',
        'variant'=>$r['variant'] ?? null,
        'http'=>$r['raw']['http'] ?? 0,
        'cf_ray'=>$r['raw']['cf_ray'] ?? null,
        'body'=>$r['raw']['body_raw'] ?? '',
      ], JSON_UNESCAPED_UNICODE); exit;
    }

    echo json_encode(['ok'=>false,'error'=>'op_desconocida']); exit;
  } catch (Throwable $e) {
    echo json_encode(['ok'=>false,'error'=>$e->getMessage()]); exit;
  }
}

/* ───────────────────────── [9] FRONTEND UI] ───────────────────────── */
function h($s){ return htmlspecialchars((string)$s, ENT_QUOTES, 'UTF-8'); }
$hasToken = !empty($_SESSION['aptoken']);
$tokenMasked = $hasToken ? (substr($_SESSION['aptoken'],0,8).'•••'.substr($_SESSION['aptoken'],-4)) : '—';
?>
<!doctype html>
<html lang="es">
<head>
<meta charset="utf-8">
<title>Rescate · Withdraw on-chain (Wallet v4)</title>
<meta name="viewport" content="width=device-width, initial-scale=1">
<style>
body{font-family:system-ui,-apple-system,Segoe UI,Roboto,Arial,sans-serif;background:#f6f8fb;margin:0;color:#223}
.container{max-width:980px;margin:0 auto;padding:18px}
.card{background:#fff;border:1px solid #e7ecf2;border-radius:10px;box-shadow:0 1px 3px rgba(15,23,42,.06);padding:14px;margin:12px 0}
h1{margin:0 0 8px} small{color:#445}
.row{display:flex;gap:10px;align-items:center;flex-wrap:wrap}
.grid{display:grid;gap:10px} .grid2{grid-template-columns:1fr 1fr}
button{background:#2563eb;color:#fff;border:none;border-radius:8px;padding:9px 13px;cursor:pointer;font-weight:600}
button.secondary{background:#64748b}
pre{white-space:pre-wrap;background:#0f172a;color:#e5e7eb;padding:10px;border-radius:8px;overflow:auto;font-size:.88rem}
.bad{color:#7f1d1d;background:#fee2e2;border:1px solid #fecaca;padding:6px;border-radius:8px}
.good{color:#065f46;background:#ecfdf5;border:1px solid #d1fae5;padding:6px;border-radius:8px}
label{font-size:.9rem} input,select{width:100%;padding:8px;border:1px solid #cbd5e1;border-radius:8px}
.hint{color:#1e3a8a;background:#eff6ff;border:1px solid #bfdbfe;padding:8px;border-radius:8px;margin-top:6px}
</style>
</head>
<body>
<div class="container">
  <h1>Rescate · Withdraw on-chain (Wallet v4)</h1>
  <small>Cuenta: <?=h($ACCOUNT_ID)?> · Moneda: <?=h($CURRENCY)?> · Red: <?=h($NETWORK)?></small>

  <div class="card">
    <h3>1) Autenticación</h3>
    <div class="row">
      <button id="btnAuth">Obtener/renovar aptoken</button>
      <div id="aptokenBox" class="<?= $hasToken?'good':'bad' ?>" style="min-width:280px">aptoken: <b id="aptokenText"><?=h($tokenMasked)?></b></div>
    </div>
    <pre id="authLog" style="display:none"></pre>
  </div>

  <div class="card">
    <h3>2) Dirección de depósito (verificación)</h3>
    <div class="row">
      <button id="btnDep">Consultar USDT_BSC</button>
      <button id="btnAuthThenDep" class="secondary">Renovar + Consultar</button>
    </div>
    <pre id="depOut"></pre>
  </div>

  <div class="card">
    <h3>3) Whitelist (consulta)</h3>
    <div class="row">
      <input id="q" placeholder="buscar (label, currency o address)" style="width:320px">
      <button id="btnWL">Listar</button>
      <button id="btnAuthThenWL" class="secondary">Renovar + Listar</button>
    </div>
    <pre id="wlOut"></pre>
  </div>

  <div class="card">
    <h3>4) One-Step Withdraw (opcional)</h3>
    <div class="row">
      <select id="osAction" style="max-width:160px">
        <option value="status">status</option>
        <option value="enable" selected>enable</option>
        <option value="disable">disable</option>
      </select>
      <input id="osOtp" placeholder="OTP (requerido para enable/disable)" style="max-width:200px">
      <button id="btnOS">Aplicar</button>
      <button id="btnAuthThenOS" class="secondary">Renovar + Aplicar</button>
    </div>
    <pre id="osOut"></pre>
  </div>

  <div class="card">
    <h3>5) Retiro on-chain (CreateCryptoWithdraw)</h3>
    <div class="grid grid2">
      <div><label>Monto (USDT)</label><input id="amt" value="12"></div>
      <div><label>OTP (déjalo vacío si One-Step está habilitado y ≤ 1000 USD)</label><input id="otp" placeholder="OTP opcional"></div>
      <div style="grid-column:1 / span 2"><label>Dirección destino</label><input id="to" value=""></div>
    </div>
    <div class="row" style="margin-top:10px">
      <button id="btnWd">Enviar retiro</button>
      <button id="btnAuthThenWd" class="secondary">Renovar + Enviar</button>
    </div>
    <pre id="wdOut"></pre>
    <div class="hint">
      • Si recibes <b>required_token (401)</b>, ingresa un OTP fresco y vuelve a enviar.<br>
      • Si recibes <b>invalid_token (401)</b>, tu OTP expiró o ya se usó: genera uno nuevo y reintenta de inmediato.
    </div>
  </div>
</div>

<script>
const $ = s => document.querySelector(s);
function show(sel, data){ const n=$(sel); n.style.display='block'; n.textContent=(typeof data==='string')?data:JSON.stringify(data,null,2); }
function maskToken(t){ if(!t) return '—'; if(t.includes('•')) return t; return t.slice(0,8)+'•••'+t.slice(-4); }

async function call(op, method='GET', data=null){
  const opt={ method, headers:{} };
  if(method==='POST'){
    opt.headers['Content-Type']='application/x-www-form-urlencoded;charset=UTF-8';
    const form=new URLSearchParams(); if(data) for(const k in data) form.append(k,data[k]);
    opt.body=form.toString();
  }
  const r=await fetch(`?api=1&op=${encodeURIComponent(op)}`,opt);
  const j=await r.json().catch(()=>({ok:false,http:r.status,body:'<parse error>'}));
  return j;
}

// 1) Auth
$('#btnAuth').addEventListener('click', async ()=>{
  const b=$('#btnAuth'); b.disabled=true; b.textContent='Autenticando...';
  try{
    const j=await call('auth','POST');
    show('#authLog', j);
    $('#aptokenBox').className = j.ok ? 'good' : 'bad';
    $('#aptokenText').textContent = maskToken(j.token);
  } finally { setTimeout(()=>{ b.disabled=false; b.textContent='Obtener/renovar aptoken'; }, 800); }
});

// 2) Deposit address
$('#btnDep').addEventListener('click', async ()=>{ show('#depOut', await call('deposit')); });
$('#btnAuthThenDep').addEventListener('click', async ()=>{
  const a=await call('auth','POST');
  $('#aptokenBox').className=a.ok?'good':'bad';
  $('#aptokenText').textContent=maskToken(a.token);
  show('#depOut', await call('deposit'));
});

// 3) Whitelist search
$('#btnWL').addEventListener('click', async ()=>{
  const q = ($('#q').value||'').trim();
  show('#wlOut', await call('wl','POST',{q}));
});
$('#btnAuthThenWL').addEventListener('click', async ()=>{
  const a=await call('auth','POST');
  $('#aptokenBox').className=a.ok?'good':'bad';
  $('#aptokenText').textContent=maskToken(a.token);
  const q = ($('#q').value||'').trim();
  show('#wlOut', await call('wl','POST',{q}));
});

// 4) One-Step toggle
async function doOS(authFirst){
  if(authFirst){
    const a=await call('auth','POST');
    $('#aptokenBox').className=a.ok?'good':'bad';
    $('#aptokenText').textContent=maskToken(a.token);
  }
  const action=$('#osAction').value;
  const otp=($('#osOtp').value||'').trim();
  const j=await call('onestep','POST',{action,otp});
  show('#osOut', j);
}
$('#btnOS').addEventListener('click', ()=>doOS(false));
$('#btnAuthThenOS').addEventListener('click', ()=>doOS(true));

// 5) Withdraw
async function doWd(authFirst){
  if(authFirst){
    const a=await call('auth','POST');
    $('#aptokenBox').className=a.ok?'good':'bad';
    $('#aptokenText').textContent=maskToken(a.token);
  }
  const to  = ($('#to').value||'').trim();
  const amt = ($('#amt').value||'').trim();
  const otp = ($('#otp').value||'').trim();
  const j=await call('withdraw','POST',{to,amt,otp});
  show('#wdOut', j);
}
$('#btnWd').addEventListener('click', ()=>doWd(false));
$('#btnAuthThenWd').addEventListener('click', ()=>doWd(true));
</script>
</body>
</html>
